#ifndef ___STARSHIP_H___
#define ___STARSHIP_H___

#include "msxvideo.h"
#include "starship.h"

#define STARSHIP_SPACE_FACTOR 4
#define STARSHIP_MAX_BULLETS 5

typedef struct ___bullet {
  int x,y,vy;
  char color;
} bullet, *pbullet;

typedef struct ___starship {
  int x, y, vx, vy;
  int xmin, ymin, xmax, ymax;
  int life;

  //bullet b[STARSHIP_MAX_BULLETS];
  bullet* b;
  int bsize;
  int ship_sprite_offset;
  int bullet_sprite_offset;
  int big;  
  int spd;
} starship, *pstarship;

void starship_update(pstarship s, char direction);

void starship_plot(pstarship s, char color1, char color2, char color3);

void starship_mem_alloc(pstarship s);

void starship_setup(
  pstarship s, int x, int y, 
  int xmin, int xmax, int ymin, int ymax,
  int life,
  int ship_sprite_offset,
  int bullet_sprite_offset,
  int big, int spd
);

void starship_shoot(pstarship s, int vy);
void starship_kill_bullet(pstarship s, int i);
void starship_kill_all_bullets(pstarship ship);

char starship_detect_explosion(pstarship shooter, pstarship target);

#endif

